PowerShell Script to Install Zoho Assist UnAttended Agent
#==========================================

#To install agent in AruzeAD Environment
#===================================================================


$errorActionPreference="Stop"
$drivePath= [Environment]::ExpandEnvironmentVariables('%SYSTEMROOT%')
$drivePath += "\temp"

if(!(Test-Path $drivePath)){
	New-Item -ItemType Directory -Path $drivePath
}
Write-Output $drivePath

[bool] $isAgentInstalled = $false

$regkey = 'HKLM:software\zoho assist\unattended remote support'
if(Test-Path $regkey){
$isAgentInstalled = $true
}
else{
	$regkey = 'HKLM:software\Wow6432Node\zoho assist\unattended remote support'
	if(Test-Path $regkey){
		$isAgentInstalled = $true
	}
}

if($isAgentInstalled -eq $false )
{
[string]$msifile = <ZA_ACCESS_MSI_URL>
[string]$jsonFile = <ZA_ACCESS_INFO_JSON_URL>

$Destination = "$drivePath\ZA_Access.msi"
Write-Output $Destination
$link1 = Invoke-WebRequest -uri $msifile -OutFile $Destination

$Destination2 = "$drivePath\info.json"
Write-Output $Destination2
$link2 = Invoke-WebRequest -uri $jsonFile -OutFile $Destination2

cmd /c "msiexec.exe /i $Destination /quiet /qn /lv $drivePath\ZAInstaller.log SILENT=TRUE"
}
