### Expense Manager
Note down and keep track of all your expenses from Expense Manager Bot.

Callback: POST /api/v1/expenses

### Components
1. **Bot** - Expense Manager
    + **Bot Handlers** - Welcome Handler, Message Handler
    + **Bot Actions** - Add Expense, View Expenses, Settings
2. **Form Function** - expensemanagerform
3. **Button Function** - expensemanagerbtn

### Prerequisites
1. Install [Node.js](https://nodejs.org/en/) version 14 or latest.
2. Install [MongoDB](https://docs.mongodb.com/manual/installation/) version 5 or latest.
3. Clone this repository using ```git clone```.

### Run the app locally
1. Install the dependencies by typing ```npm install```.
2. Start the MongoDB server ```mongod```.
3. Configure the application credentials & MongoDB Server URL in [config/dev.js](config/dev.js) file.
4. Start the application by typing ```npm start```.

### Deploy the app in Microsoft Azure - App Service

1. Sign In to [Microsoft Azure Portal](https://portal.azure.com/) and choose **App Services** from the home page to create a web app.
2. Fill in the deployment details. Select **Node 14** as runtime stack and proceed further.
3. Once the initial deployment is completed, go to the resource page and click **Configuration** on the LHS Menu.
4. Add all the application credentials and MongoDB connection string as environment variables under the **Application Settings**.
	+ Refer to the [help doc](https://www.mongodb.com/how-to-setup-mongodb-atlas-on-azure) to create a database in MongoDB Atlas.
5. Make sure to set ```NODE_ENV``` value as ```production```. 
6. Go to **Deployment Center**, select the code source and save.
7. Copy the app URL from **Overview** page and use it as extension's callback URL in Zoho Cliq's [developer page](https://cliq.zoho.com/developer).