const CommonUtil = require("../utils/commonUtil");	//NO I18N
const DatabaseUtil = require("../utils/databaseUtil");	//NO I18N

const Bots = (function () {
	let reqData;
	const _handler = async (data) => {
		_initialize(data);
		let response;
		const handler = reqData.handler.type;
		switch (handler) {
			case "welcome_handler":	//NO I18N
				response = _welcomeHandler();
				break;
			case "message_handler":	//NO I18N
				response = _messageHandler();
				break;
			case "action_handler":	//NO I18N
				response = await _actionHandler();
		}
		return response;
	};

	const _initialize = (data) => {
		reqData = data;
	};

	const _welcomeHandler = () => {
		return {
			text: "Hey! Thanks for subscribing :happy: \nUse the below actions to manage all your expenses."	//NO I18N
		};
	};

	const _messageHandler = () => {
		return { text: "Hey! Use the bot actions to manage all your expenses." };	//NO I18N
	};

	const _actionHandler = async () => {
		const zuid = reqData.params.access.user_id;
		if (!(await DatabaseUtil.users.doesUserExists(zuid))) {
			await DatabaseUtil.users.addUser(zuid);
		}

		const isTokenAdded = await DatabaseUtil.users.isTokenAdded(zuid);
		if (!isTokenAdded) {
			return CommonUtil.getAuthButtonResponse();
		}

		const { currency, notifications } = await DatabaseUtil.users.getUserSettings(zuid);

		const actionName = reqData.handler.name;
		switch (actionName) {
			case "Add Expense":	//NO I18N
				return await _addExpense(zuid, currency);
			case "View Expenses":	//NO I18N
				return await _viewExpenses(currency);
			case "Settings":	//NO I18N
				return await _settings(currency, notifications);
		}
	};

	const _addExpense = async (zuid, currency) => {
		try {
			if (currency === undefined) {
				return CommonUtil.getSettingsResponse();
			}

			let today = CommonUtil.formatDateWOTime(new Date());
			let response = {
				name: "addexpenseform",	//NO I18N
				type: "form",	//NO I18N
				title: "Add Expense",	//NO I18N
				button_label: "Add",	//NO I18N
				inputs: [
					{
						type: "number",	//NO I18N
						name: "amount",	//NO I18N
						label: "Amount in " + (await DatabaseUtil.users.getCurrency(zuid)),	//NO I18N
						hint: "Please enter the amount you spent.",	//NO I18N
						placeholder: "3000",
						mandatory: true,
						min: "1",
						max: "100000"
					},
					{
						type: "date",	//NO I18N
						name: "date",	//NO I18N
						label: "Expense Date",	//NO I18N
						hint: "Mention when you spent the amount.",	//NO I18N
						placeholder: today,
						value: today,
						mandatory: true
					},
					{
						type: "select",	//NO I18N
						name: "category",	//NO I18N
						label: "Category",	//NO I18N
						hint: "Choose an appropriate category you spent on.",	//NO I18N
						placeholder: "Shopping",	//NO I18N
						options: [
							{ label: "Food and Drinks", value: 1 },	//NO I18N
							{ label: "Health", value: 2 },	//NO I18N
							{ label: "Leisure", value: 3 },	//NO I18N
							{ label: "Rent", value: 4 },	//NO I18N
							{ label: "Shopping", value: 5 },	//NO I18N
							{ label: "Transportation", value: 6 },	//NO I18N
							{ label: "Utilites", value: 7 },	//NO I18N
							{ label: "Others", value: 8 }	//NO I18N
						]
					},
					{
						type: "text",	//NO I18N
						name: "note",	//NO I18N
						label: "Note",	//NO I18N
						hint: "Add a note",	//NO I18N
						placeholder: "Bought a shirt for Steve",	//NO I18N
						max_length: "100"	//NO I18N
					}
				],
				action: {
					type: "invoke.function",	//NO I18N
					name: "expensemanagerform"	//NO I18N
				}
			};
			return response;
		} catch (error) {
			throw error;
		}
	};

	const _viewExpenses = async (currency) => {
		try {
			if (currency === undefined) {
				return CommonUtil.getSettingsResponse();
			}

			let buttons = [];
			const buttonLabels = ["This Week", "This Month", "This Year"];	//NO I18N
			buttonLabels.forEach((label) => {
				buttons.push({
					label: label,
					action: { type: "invoke.function", data: { name: "expensemanagerbtn" } }	//NO I18N
				});
			});

			let response = {
				text: "Get the list of expenses.",	//NO I18N
				card: {
					title: "Expense History",	//NO I18N
					theme: "modern-inline"	//NO I18N
				},
				buttons: buttons
			};
			return response;
		} catch (error) {
			throw error;
		}
	};

	const _settings = async (currency, notifications) => {
		try {
			let notificationFrequency;
			if (typeof notifications !== "undefined") {
				notificationFrequency = notifications.frequency === "Weekly" ? "0" : "1";	//NO I18N
			}
			return CommonUtil.getSettingsResponse(currency, notificationFrequency);
		} catch (error) {
			throw error;
		}
	};

	return {
		handler: _handler
	};
})();

module.exports = Bots;
