const schedule = require("node-schedule");	//NO I18N
const crypto = require("crypto");	//NO I18N
const axios = require("axios");	//NO I18N

const config = require("../../config/appKeys");	//NO I18N

const DatabaseUtil = require("./databaseUtil");	//NO I18N
const CommonUtil = require("./commonUtil");	//NO I18N

const Scheduler = (function () {
	const _create = (zuid, frequency) => {
		return _schedule(zuid, frequency);
	};

	const _update = async (zuid, frequency) => {
		await _stop(zuid);
		return _schedule(zuid, frequency);
	};

	const _schedule = (zuid, frequency) => {
		try {
			const schedulerId = crypto.randomUUID();
			schedule.scheduleJob(schedulerId, _getCornString(frequency), async () => {
				try {
					const url = `${config.CLIQ_BOT_MESSAGE_ENDPOINT}?appkey=${
						config.CLIQ_APP_KEY
					}&zapikey=${await DatabaseUtil.users.getToken(zuid)}`;

					let fromDate = CommonUtil.getLastMonday(true);
					let toDate = CommonUtil.getYesterday();
					if (frequency === "Monthly") {
						fromDate = CommonUtil.getFirstDayOfCurrentMonth(true);
					}

					let messageCard;
					const allExpenses = await DatabaseUtil.expenses.getExpense(
						zuid,
						fromDate,
						toDate
					);
					if (allExpenses.length === 0) {
						messageCard = {
							text:
								"No expense for this " +	//NO I18N
								(frequency === "Weekly" ? "week" : "month") +	//NO I18N
								".",
							card: {
								title: "Being in control of your expenses!!!",	//NO I18N
								theme: "modern-inline"	//NO I18N
							}
						};
					} else {
						messageCard = CommonUtil.getExpenseResponse(allExpenses, frequency, {
							fromDate,
							toDate,
							month: CommonUtil.getMonthName(fromDate.getMonth() + 1),
							currency: await DatabaseUtil.users.getCurrency(zuid)
						});
					}
					await axios.post(url, messageCard);
				} catch (error) {
					if (error.response) {
						if (error.response.status === 401) {
							await _stop(zuid);
							await DatabaseUtil.users.removeToken(zuid);
						}
					}
				}
			});
			return schedulerId;
		} catch (error) {
			throw error;
		}
	};

	const _stop = async (zuid) => {
		try {
			const schedulerId = await DatabaseUtil.users.getSchedulerId(zuid);
			const scheduler = schedule.scheduledJobs[schedulerId];
			if (!scheduler.cancel()) {
				throw new Error("Unable to cancel scheduler: No notifications scheduled");	//NO I18N
			}
		} catch (error) {
			throw error;
		}
	};

	const _getCornString = (notificationFrequency) => {
		if (notificationFrequency === "Weekly") {
			return "0 9 * * 1";
		} else if (notificationFrequency === "Monthly") {	//NO I18N
			return "0 9 1 * *";
		}
	};

	return {
		create: _create,
		update: _update
	};
})();

module.exports = Scheduler;
