'use strict'; //NO I18N

const cliq = require('zcatalyst-integ-cliq'); //NO I18N
const axios = require('axios'); //NO I18N
const messageActionHandler = cliq.messageAction();

messageActionHandler.executionHandler(async(req, res) => {
    let text = "";
    let url = req.message.text.trim() || "";
    if (url === "") {
        text = "It's empty"; //NO I18N
    } else {
        text = await getShortenedUrl(url);
    }
    res.setText(text);
    return res;
});

async function getShortenedUrl(url) {
    try {
        let response = await axios.post('https://cleanuri.com/api/v1/shorten', { //NO I18N
            url: url
        });
        return "Short URL : ```" + response.data.result_url + "```"; //NO I18N
    } catch (e) {
        return "Seems to be invalid URL."; //NO I18N
    }
}
