/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.Logger$;
import com.zoho.api.logger.Logger$Levels$;
import com.zoho.api.logger.SDKLogger;
import com.zoho.api.logger.SDKLogger$;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.RequestProxy;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Constants$;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import scala.;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;

public final class Initializer$ {
    public static final Initializer$ MODULE$ = new Initializer$();
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private static JSONObject jsonDetails;
    private static final ThreadLocal<Initializer> LOCAL;
    private static Initializer initializer;

    static {
        LOCAL = new ThreadLocal();
    }

    private Logger LOGGER() {
        return LOGGER;
    }

    public JSONObject jsonDetails() {
        return jsonDetails;
    }

    public void jsonDetails_$eq(JSONObject x$1) {
        jsonDetails = x$1;
    }

    private ThreadLocal<Initializer> LOCAL() {
        return LOCAL;
    }

    private Initializer initializer() {
        return initializer;
    }

    private void initializer_$eq(Initializer x$1) {
        initializer = x$1;
    }

    public void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath, Option<com.zoho.api.logger.Logger> logger, Option<RequestProxy> proxy) throws SDKException {
        try {
            com.zoho.api.logger.Logger logger1 = (com.zoho.api.logger.Logger)logger.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (user == null) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.USERSIGNATURE_ERROR_MESSAGE());
            }
            if (environment == null) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.ENVIRONMENT_ERROR_MESSAGE());
            }
            if (token == null) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.TOKEN_ERROR_MESSAGE());
            }
            if (store == null) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.STORE_ERROR_MESSAGE());
            }
            if (sdkConfig == null) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.SDK_CONFIG_ERROR_MESSAGE());
            }
            if (resourcePath == null || resourcePath.isEmpty()) {
                throw new SDKException(Constants$.MODULE$.INITIALIZATION_ERROR(), Constants$.MODULE$.RESOURCE_PATH_ERROR_MESSAGE());
            }
            if (logger1 == null) {
                String filePath = new StringBuilder(0).append(System.getProperty("user.dir")).append(File.separator).append(Constants$.MODULE$.LOGFILE_NAME()).toString();
                logger1 = Logger$.MODULE$.getInstance(Logger$Levels$.MODULE$.INFO(), filePath);
            }
            SDKLogger$.MODULE$.initialize(logger1);
            try {
                this.jsonDetails_$eq(this.getJSONDetails());
            }
            catch (IOException e) {
                throw new SDKException(Constants$.MODULE$.JSON_DETAILS_ERROR(), e);
            }
            this.initializer_$eq(new Initializer());
            this.initializer().com$zoho$crm$api$Initializer$$user_$eq(user);
            this.initializer().com$zoho$crm$api$Initializer$$environment_$eq(environment);
            this.initializer().com$zoho$crm$api$Initializer$$token_$eq(token);
            this.initializer().com$zoho$crm$api$Initializer$$store_$eq(store);
            this.initializer().com$zoho$crm$api$Initializer$$sdkConfig_$eq(sdkConfig);
            this.initializer().com$zoho$crm$api$Initializer$$resourcePath_$eq(resourcePath);
            this.initializer().com$zoho$crm$api$Initializer$$requestProxy_$eq((RequestProxy)proxy.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            this.LOGGER().log(Level.INFO, Constants$.MODULE$.INITIALIZATION_SUCCESSFUL().concat(this.initializer().toString()));
        }
        catch (SDKException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SDKException(Constants$.MODULE$.INITIALIZATION_EXCEPTION(), e);
        }
    }

    public Option<com.zoho.api.logger.Logger> initialize$default$7() {
        return None$.MODULE$;
    }

    public Option<RequestProxy> initialize$default$8() {
        return None$.MODULE$;
    }

    public Initializer getInitializer() {
        if (this.LOCAL().get() != null) {
            return this.LOCAL().get();
        }
        return this.initializer();
    }

    public void switchUser(UserSignature user, DataCenter.Environment environment, Token token, SDKConfig sdkConfig, Option<RequestProxy> proxy) throws SDKException {
        if (user == null) {
            throw new SDKException(Constants$.MODULE$.SWITCH_USER_ERROR(), Constants$.MODULE$.USERSIGNATURE_ERROR_MESSAGE());
        }
        if (environment == null) {
            throw new SDKException(Constants$.MODULE$.SWITCH_USER_ERROR(), Constants$.MODULE$.ENVIRONMENT_ERROR_MESSAGE());
        }
        if (token == null) {
            throw new SDKException(Constants$.MODULE$.SWITCH_USER_ERROR(), Constants$.MODULE$.TOKEN_ERROR_MESSAGE());
        }
        if (sdkConfig == null) {
            throw new SDKException(Constants$.MODULE$.SWITCH_USER_ERROR(), Constants$.MODULE$.SDK_CONFIG_ERROR_MESSAGE());
        }
        Initializer initializer = new Initializer();
        initializer.com$zoho$crm$api$Initializer$$user_$eq(user);
        initializer.com$zoho$crm$api$Initializer$$environment_$eq(environment);
        initializer.com$zoho$crm$api$Initializer$$token_$eq(token);
        initializer.com$zoho$crm$api$Initializer$$store_$eq(this.initializer().com$zoho$crm$api$Initializer$$store());
        initializer.com$zoho$crm$api$Initializer$$sdkConfig_$eq(sdkConfig);
        initializer.com$zoho$crm$api$Initializer$$resourcePath_$eq(this.initializer().com$zoho$crm$api$Initializer$$resourcePath());
        initializer.com$zoho$crm$api$Initializer$$requestProxy_$eq((RequestProxy)proxy.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.LOCAL().set(initializer);
        this.LOGGER().log(Level.INFO, Constants$.MODULE$.INITIALIZATION_SWITCHED().concat(initializer.toString()));
    }

    public Option<RequestProxy> switchUser$default$5() {
        return None$.MODULE$;
    }

    public JSONObject getJSONDetails() {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String fileContent = "";
        try {
            try {
                is = Initializer.class.getClass().getResourceAsStream(Constants$.MODULE$.JSON_DETAILS_FILE_PATH());
                isr = new InputStreamReader(is);
                br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    fileContent = new StringBuilder(0).append(fileContent).append(line).toString();
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                this.LOGGER().log(Level.FINE, Constants$.MODULE$.EXCEPTION_JSONDETAILS(), e);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return new JSONObject(fileContent);
    }

    public JSONObject getJSON(String filePath) throws IOException {
        return new JSONObject(new String(Files.readAllBytes(Paths.get(filePath, new String[0]))));
    }

    private Initializer$() {
    }
}

