/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.logger;

import com.zoho.api.logger.Logger;
import com.zoho.api.logger.SDKLogger$;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Constants$;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001D\u0007\t\u0002Y1Q\u0001G\u0007\t\u0002eAQ\u0001I\u0001\u0005\u0002\u0005BqAI\u0001C\u0002\u0013%1\u0005\u0003\u0004/\u0003\u0001\u0006I\u0001\n\u0005\u0006_\u0005!\t\u0001\r\u0004\u0005o\u0005!\u0001\bC\u0003!\r\u0011\u00051\bC\u0003?\r\u0011\u0005sH\u0002\u0003\u0019\u001b\u0001\u0001\u0006\u0002\u0003\b\n\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000b\u0001JA\u0011C)\u0002\u0013M#5\nT8hO\u0016\u0014(B\u0001\b\u0010\u0003\u0019awnZ4fe*\u0011\u0001#E\u0001\u0004CBL'B\u0001\n\u0014\u0003\u0011Qx\u000e[8\u000b\u0003Q\t1aY8n\u0007\u0001\u0001\"aF\u0001\u000e\u00035\u0011\u0011b\u0015#L\u0019><w-\u001a:\u0014\u0005\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002-\u00051AjT$H\u000bJ+\u0012\u0001\n\t\u0003K1j\u0011A\n\u0006\u0003O!\nq\u0001\\8hO&twM\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0014\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\n!\"\u001b8ji&\fG.\u001b>f)\t\tD\u0007\u0005\u0002\u001ce%\u00111\u0007\b\u0002\u0005+:LG\u000fC\u0003\u000f\u000b\u0001\u0007Q\u0007\u0005\u0002\u0018m%\u0011Q&\u0004\u0002\n\r>\u0014X.\u0019;uKJ\u001c\"AB\u001d\u0011\u0005\u0015R\u0014BA\u001c')\u0005a\u0004CA\u001f\u0007\u001b\u0005\t\u0011A\u00024pe6\fG\u000f\u0006\u0002A\u0017B\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"a\u0011\u000f\u000e\u0003\u0011S!!R\u000b\u0002\rq\u0012xn\u001c;?\u0013\t9E$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$\u001d\u0011\u0015a\u0005\u00021\u0001N\u0003\u0019\u0011XmY8sIB\u0011QET\u0005\u0003\u001f\u001a\u0012\u0011\u0002T8h%\u0016\u001cwN\u001d3\u0014\u0005%QBC\u0001*T!\t9\u0012\u0002C\u0003\u000f\u0017\u0001\u0007Q\u0007")
public class SDKLogger {
    public static void initialize(Logger logger) {
        SDKLogger$.MODULE$.initialize(logger);
    }

    public SDKLogger(Logger logger) {
        try {
            if (logger.getFilePath() != null) {
                String string = logger.getFilePath();
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    FileHandler fileHandler = new FileHandler(logger.getFilePath(), true);
                    SDKLogger$.MODULE$.com$zoho$api$logger$SDKLogger$$LOGGER().addHandler(fileHandler);
                    SDKLogger$.MODULE$.com$zoho$api$logger$SDKLogger$$LOGGER().setUseParentHandlers(false);
                    fileHandler.setFormatter(new Formatter());
                }
            }
            if (logger.getLevel() != null && Constants$.MODULE$.LOGGER_LEVELS().contains((Object)logger.getLevel())) {
                SDKLogger$.MODULE$.com$zoho$api$logger$SDKLogger$$LOGGER().setLevel((Level)Constants$.MODULE$.LOGGER_LEVELS().apply((Object)logger.getLevel()));
            }
        }
        catch (Exception e) {
            throw new SDKException(Constants$.MODULE$.SDK_LOGGER_INITIALIZE(), e);
        }
    }

    private static class Formatter
    extends java.util.logging.Formatter {
        @Override
        public String format(LogRecord record) {
            BoxedUnit boxedUnit;
            StringBuilder sb = new StringBuilder();
            sb.append((Object)new Date(record.getMillis())).append(" ").append(record.getLoggerName()).append(": ").append(record.getLevel().getLocalizedName()).append(" ").append(record.getSourceClassName()).append(" ").append(record.getSourceMethodName()).append(": ").append(this.formatMessage(record));
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    boxedUnit = sb.append(" ").append(sw.toString());
                }
                catch (Exception ex) {
                    java.util.logging.Logger.getGlobal().log(Level.INFO, ex.toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

