/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.crm.api.util.DataTypeConverter;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DataTypeConverter$ {
    public static final DataTypeConverter$ MODULE$ = new DataTypeConverter$();
    private static final HashMap<String, DataTypeConverter.PreConverter<?>> PRE_CONVERTER_MAP = new HashMap();
    private static final HashMap<String, DataTypeConverter.PostConverter<?>> POST_CONVERTER_MAP = new HashMap();

    private HashMap<String, DataTypeConverter.PreConverter<?>> PRE_CONVERTER_MAP() {
        return PRE_CONVERTER_MAP;
    }

    private HashMap<String, DataTypeConverter.PostConverter<?>> POST_CONVERTER_MAP() {
        return POST_CONVERTER_MAP;
    }

    private synchronized void init() {
        if (!this.PRE_CONVERTER_MAP().isEmpty() && !this.POST_CONVERTER_MAP().isEmpty()) {
            return;
        }
        DataTypeConverter.PreConverter<LocalDate> dateTimePreConverter = new DataTypeConverter.PreConverter<LocalDate>(){

            public LocalDate convert(Object obj) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return LocalDate.parse(obj.toString(), formatter);
            }
        };
        DataTypeConverter.PostConverter<LocalDate> dateTimePostConverter = new DataTypeConverter.PostConverter<LocalDate>(){

            public Object convert(LocalDate obj) {
                LocalDate date = obj;
                return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
        };
        DataTypeConverter.PreConverter<OffsetDateTime> offsetDatePreConverter = new DataTypeConverter.PreConverter<OffsetDateTime>(){

            public OffsetDateTime convert(Object obj) {
                return OffsetDateTime.ofInstant(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(obj.toString())), ZoneId.systemDefault());
            }
        };
        DataTypeConverter.PostConverter<OffsetDateTime> offsetDatePostConverter = new DataTypeConverter.PostConverter<OffsetDateTime>(){

            public Object convert(OffsetDateTime dateTime) {
                return dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
        };
        DataTypeConverter.PreConverter<String> stringPreConverter = new DataTypeConverter.PreConverter<String>(){

            public String convert(Object obj) {
                return obj.toString();
            }
        };
        DataTypeConverter.PostConverter<String> stringPostConverter = new DataTypeConverter.PostConverter<String>(){

            public Object convert(String r) {
                return r;
            }
        };
        DataTypeConverter.PreConverter<Object> longPreConverter = new DataTypeConverter.PreConverter<Object>(){

            public Object convert(Object obj) {
                if (obj.toString().equalsIgnoreCase("null")) {
                    return null;
                }
                return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(obj.toString())));
            }
        };
        DataTypeConverter.PostConverter<Object> longPostConverter = new DataTypeConverter.PostConverter<Object>(){

            public Object convert(Object r) {
                return r;
            }
        };
        DataTypeConverter.PreConverter<Object> integerPreConverter = new DataTypeConverter.PreConverter<Object>(){

            public int convert(Object obj) {
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(obj.toString()));
            }
        };
        DataTypeConverter.PostConverter<Object> integerPostConverter = new DataTypeConverter.PostConverter<Object>(){

            public Object convert(int r) {
                return BoxesRunTime.boxToInteger((int)r);
            }
        };
        DataTypeConverter.PreConverter<Object> booleanPreConverter = new DataTypeConverter.PreConverter<Object>(){

            public boolean convert(Object obj) {
                return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(obj.toString()));
            }
        };
        DataTypeConverter.PostConverter<Object> booleanPostConverter = new DataTypeConverter.PostConverter<Object>(){

            public final Object convert(boolean r) {
                return DataTypeConverter$.com$zoho$crm$api$util$DataTypeConverter$$$anonfun$init$1(r);
            }
        };
        DataTypeConverter.PreConverter<Object> doublePreConverter = new DataTypeConverter.PreConverter<Object>(){

            public double convert(Object obj) {
                return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(obj.toString()));
            }
        };
        DataTypeConverter.PostConverter<Object> doublePostConverter = new DataTypeConverter.PostConverter<Object>(){

            public Object convert(double r) {
                return BoxesRunTime.boxToDouble((double)r);
            }
        };
        DataTypeConverter.PreConverter<Object> objPreConverter = new DataTypeConverter.PreConverter<Object>(){

            public Object convert(Object obj) {
                return DataTypeConverter$.MODULE$.com$zoho$crm$api$util$DataTypeConverter$$preConvertObjectData(obj);
            }
        };
        DataTypeConverter.PostConverter<Object> objPostConverter = new DataTypeConverter.PostConverter<Object>(){

            public Object convert(Object obj) {
                return DataTypeConverter$.MODULE$.com$zoho$crm$api$util$DataTypeConverter$$postConvertObjectData(obj);
            }
        };
        this.addToHashMap(LocalDate.class.getName(), dateTimePreConverter, dateTimePostConverter);
        this.addToHashMap(OffsetDateTime.class.getName(), offsetDatePreConverter, offsetDatePostConverter);
        this.addToHashMap(String.class.getName(), stringPreConverter, stringPostConverter);
        this.addToHashMap(Long.class.getName(), longPreConverter, longPostConverter);
        this.addToHashMap(Integer.class.getName(), integerPreConverter, integerPostConverter);
        this.addToHashMap(Integer.class.getName(), integerPreConverter, integerPostConverter);
        this.addToHashMap(Boolean.class.getName(), booleanPreConverter, booleanPostConverter);
        this.addToHashMap(Double.class.getName(), doublePreConverter, doublePostConverter);
        this.addToHashMap(Object.class.getName(), objPreConverter, objPostConverter);
    }

    public Object com$zoho$crm$api$util$DataTypeConverter$$preConvertObjectData(Object obj) throws Exception {
        Object object;
        if (obj == null) {
            return null;
        }
        Object object2 = obj;
        if (object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object2;
            ArrayBuffer values = new ArrayBuffer();
            if (jSONArray.length() > 0) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), jSONArray.length()).foreach((Function1 & Serializable)responseIndex -> values.addOne(DataTypeConverter$.MODULE$.com$zoho$crm$api$util$DataTypeConverter$$preConvertObjectData(jSONArray.get(BoxesRunTime.unboxToInt((Object)responseIndex)))));
            }
            object = values;
        } else if (object2 instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object2;
            scala.collection.mutable.HashMap mapInstance = new scala.collection.mutable.HashMap();
            if (jSONObject.length() > 0) {
                jSONObject.keySet().forEach(memberName -> {
                    Object jsonValue = jSONObject.get(memberName);
                    mapInstance.put(memberName, MODULE$.com$zoho$crm$api$util$DataTypeConverter$$preConvertObjectData(jsonValue));
                });
            }
            object = mapInstance;
        } else {
            object = obj.getClass().getName().equalsIgnoreCase("Object") ? obj : this.preConvert(obj, obj.getClass().getName());
        }
        return object;
    }

    public Object com$zoho$crm$api$util$DataTypeConverter$$postConvertObjectData(Object obj) throws Exception {
        Object object;
        if (obj == null) {
            return JSONObject.NULL;
        }
        Object object2 = obj;
        if (object2 instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)object2;
            JSONArray list = new JSONArray();
            arrayBuffer.foreach((Function1 & Serializable)value -> list.put(MODULE$.com$zoho$crm$api$util$DataTypeConverter$$postConvertObjectData(value)));
            object = list;
        } else if (object2 instanceof Map) {
            JSONObject value2 = new JSONObject();
            scala.collection.mutable.HashMap requestObject = (scala.collection.mutable.HashMap)obj;
            if (requestObject.nonEmpty()) {
                requestObject.keySet().foreach((Function1 & Serializable)key -> {
                    Option keyValue = requestObject.get(key);
                    return value2.put(key, MODULE$.com$zoho$crm$api$util$DataTypeConverter$$postConvertObjectData(keyValue));
                });
            }
            object = value2;
        } else {
            object = obj.getClass().getName().equalsIgnoreCase("Object") ? obj : this.postConvert(obj, obj.getClass().getName());
        }
        return object;
    }

    private <R> void addToHashMap(String name, DataTypeConverter.PreConverter<R> preConverter, DataTypeConverter.PostConverter<R> postConverter) {
        this.PRE_CONVERTER_MAP().put(name, preConverter);
        this.POST_CONVERTER_MAP().put(name, postConverter);
    }

    public <R> Object preConvert(Object obj, String type) throws Exception {
        this.init();
        return this.PRE_CONVERTER_MAP().containsKey(type) ? this.PRE_CONVERTER_MAP().get(type).convert(obj) : obj;
    }

    public <R> Object postConvert(R obj, String type) throws Exception {
        this.init();
        return this.POST_CONVERTER_MAP().containsKey(type) ? this.POST_CONVERTER_MAP().get(type).convert(obj) : obj;
    }

    public static final /* synthetic */ Object com$zoho$crm$api$util$DataTypeConverter$$$anonfun$init$1(boolean r) {
        return BoxesRunTime.boxToBoolean((boolean)r);
    }

    private DataTypeConverter$() {
    }
}

