/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class FileStore
implements TokenStore {
    private String filePath;
    private String[] headers = new String[]{"id", "user_mail", "client_id", "client_secret", "refresh_token", "access_token", "grant_token", "expiry_time", "redirect_url"};

    public FileStore(String filePath) throws Exception {
        this.filePath = filePath;
        CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), true));
        FileReader fileReader = new FileReader(this.filePath);
        if (fileReader.read() == -1) {
            csvWriter.writeNext(this.headers);
        }
        fileReader.close();
        csvWriter.flush();
        csvWriter.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token getToken(UserSignature user, Token token) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            if (!(token instanceof OAuthToken)) return null;
            OAuthToken oauthToken = (OAuthToken)token;
            List allContents = csvReader.readAll();
            int index = 1;
            while (index < allContents.size()) {
                String[] nextRecord = (String[])allContents.get(index);
                if (this.checkTokenExists(user.getEmail(), oauthToken, nextRecord).booleanValue()) {
                    String grantToken = nextRecord[6] != null && !nextRecord[6].isEmpty() ? nextRecord[6] : null;
                    String redirectURL = nextRecord[8] != null && !nextRecord[8].isEmpty() ? nextRecord[8] : null;
                    oauthToken.setId(nextRecord[0]);
                    oauthToken.setUserMail(nextRecord[1]);
                    oauthToken.setClientId(nextRecord[2]);
                    oauthToken.setClientSecret(nextRecord[3]);
                    oauthToken.setRefreshToken(nextRecord[4]);
                    oauthToken.setAccessToken(nextRecord[5]);
                    oauthToken.setGrantToken(grantToken);
                    oauthToken.setExpiresIn(String.valueOf(nextRecord[7]));
                    oauthToken.setRedirectURL(redirectURL);
                    OAuthToken oAuthToken = oauthToken;
                    return oAuthToken;
                }
                ++index;
            }
            return null;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getToken - FileStore : ", ex);
        }
    }

    @Override
    public void saveToken(UserSignature user, Token token) throws SDKException {
        try {
            String[] data = new String[9];
            if (token instanceof OAuthToken) {
                OAuthToken oauthToken = (OAuthToken)token;
                oauthToken.setUserMail(user.getEmail());
                this.deleteToken(oauthToken);
                data[0] = oauthToken.getId();
                data[1] = user.getEmail();
                data[2] = oauthToken.getClientId();
                data[3] = oauthToken.getClientSecret();
                data[4] = oauthToken.getRefreshToken();
                data[5] = oauthToken.getAccessToken();
                data[6] = oauthToken.getGrantToken();
                data[7] = oauthToken.getExpiresIn();
                data[8] = oauthToken.getRedirectURL();
            }
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), true));){
                csvWriter.writeNext(data);
                csvWriter.flush();
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in saveToken - FileStore : ", ex);
        }
    }

    @Override
    public void deleteToken(Token token) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(new File(this.filePath)));){
            if (token instanceof OAuthToken) {
                OAuthToken oauthToken = (OAuthToken)token;
                List allContents = csvReader.readAll();
                for (int index = 1; index < allContents.size(); ++index) {
                    String[] nextRecord = (String[])allContents.get(index);
                    if (!this.checkTokenExists(oauthToken.getUserMail(), oauthToken, nextRecord).booleanValue()) continue;
                    allContents.remove(index);
                    break;
                }
                CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath)));
                csvWriter.writeAll(allContents);
                csvWriter.close();
            }
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteToken - FileStore : ", ex);
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            List allContents = csvReader.readAll();
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                String grantToken = nextRecord[6] != null && !nextRecord[6].isEmpty() ? nextRecord[6] : null;
                String redirectURL = nextRecord[8] != null && !nextRecord[8].isEmpty() ? nextRecord[8] : null;
                OAuthToken oauthToken = new OAuthToken.Builder().clientID(nextRecord[2]).clientSecret(nextRecord[3]).refreshToken(nextRecord[4]).grantToken(grantToken).build();
                oauthToken.setId(nextRecord[0]);
                oauthToken.setUserMail(nextRecord[1]);
                oauthToken.setAccessToken(nextRecord[5]);
                oauthToken.setExpiresIn(String.valueOf(nextRecord[7]));
                oauthToken.setRedirectURL(redirectURL);
                tokens.add(oauthToken);
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - FileStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), false));){
            csvWriter.writeNext(this.headers);
            csvWriter.flush();
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - FileStore : ", ex);
        }
    }

    private Boolean checkTokenExists(String email, OAuthToken oauthToken, String[] row) throws SDKException {
        boolean tokenCheck;
        if (email == null) {
            throw new SDKException("USER MAIL NULL ERROR", "User Mail MUST NOT be null. Use setUserMail() to set value.");
        }
        String clientId = oauthToken.getClientId();
        String grantToken = oauthToken.getGrantToken();
        String refreshToken = oauthToken.getRefreshToken();
        boolean bl = tokenCheck = grantToken != null ? grantToken.equals(row[6]) : refreshToken.equals(row[4]);
        if (row[1].equals(email) && row[2].equals(clientId) && tokenCheck) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token getTokenById(String id, Token token) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            if (!(token instanceof OAuthToken)) return null;
            OAuthToken oauthToken = (OAuthToken)token;
            List allContents = csvReader.readAll();
            boolean isRowPresent = false;
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                if (!nextRecord[0].equals(id)) continue;
                isRowPresent = true;
                String grantToken = nextRecord[6] != null && !nextRecord[6].isEmpty() ? nextRecord[6] : null;
                String redirectURL = nextRecord[8] != null && !nextRecord[8].isEmpty() ? nextRecord[8] : null;
                oauthToken.setId(nextRecord[0]);
                oauthToken.setUserMail(nextRecord[1]);
                oauthToken.setClientId(nextRecord[2]);
                oauthToken.setClientSecret(nextRecord[3]);
                oauthToken.setRefreshToken(nextRecord[4]);
                oauthToken.setAccessToken(nextRecord[5]);
                oauthToken.setGrantToken(grantToken);
                oauthToken.setExpiresIn(String.valueOf(nextRecord[7]));
                oauthToken.setRedirectURL(redirectURL);
                OAuthToken oAuthToken = oauthToken;
                return oAuthToken;
            }
            if (isRowPresent) return null;
            throw new SDKException("TOKEN_STORE", "Exception in getTokenById - FileStore : Given ID is invalid");
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokenById - FileStore : Given ID is invalid", ex);
        }
    }
}

