/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.logger;

import com.zoho.api.logger.Logger;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Constants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SDKLogger {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SDKLogger.class.getName());

    public static void initialize(Logger logger) throws SDKException {
        new SDKLogger(logger);
    }

    private SDKLogger(Logger logger) throws SDKException {
        try {
            if (!logger.getLevel().equalsIgnoreCase(Logger.Levels.OFF.name()) && logger.getFilePath() != null && logger.getFilePath() != "") {
                FileHandler fileHandler = new FileHandler(logger.getFilePath(), true);
                LOGGER.addHandler(fileHandler);
                LOGGER.setUseParentHandlers(false);
                fileHandler.setFormatter(new Formatter());
            }
            if (logger.getLevel() != null && Constants.LOGGER_LEVELS.containsKey(logger.getLevel())) {
                LOGGER.setLevel(Constants.LOGGER_LEVELS.get(logger.getLevel()));
            }
        }
        catch (Exception e) {
            throw new SDKException("Exception in Logger Initialization : ", e);
        }
    }

    private static class Formatter
    extends java.util.logging.Formatter {
        private Formatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(new Date(record.getMillis())).append(" ").append(record.getLoggerName()).append(": ").append(record.getLevel().getLocalizedName()).append(" ").append(record.getSourceClassName()).append(" ").append(record.getSourceMethodName()).append(": ").append(this.formatMessage(record));
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    java.util.logging.Logger.getGlobal().log(Level.INFO, ex.toString());
                }
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

