/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.FileStore;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.Logger;
import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.RequestProxy;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class Initializer {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private static final ThreadLocal<Initializer> LOCAL = new ThreadLocal();
    private static Initializer initializer;
    private DataCenter.Environment environment;
    private TokenStore store;
    private UserSignature user;
    private Token token;
    public static JSONObject jsonDetails;
    private String resourcePath;
    private RequestProxy requestProxy;
    private SDKConfig sdkConfig;

    private Initializer() {
    }

    private static void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath, com.zoho.api.logger.Logger logger, RequestProxy proxy) throws SDKException {
        try {
            SDKLogger.initialize(logger);
            try {
                if (jsonDetails == null || jsonDetails.length() == 0) {
                    jsonDetails = Initializer.getJSONDetails();
                }
            }
            catch (IOException e) {
                throw new SDKException("ERROR IN READING JSONDETAILS FILE", e);
            }
            initializer = new Initializer();
            Initializer.initializer.user = user;
            Initializer.initializer.environment = environment;
            Initializer.initializer.token = token;
            Initializer.initializer.store = store;
            Initializer.initializer.sdkConfig = sdkConfig;
            Initializer.initializer.resourcePath = resourcePath;
            Initializer.initializer.requestProxy = proxy;
            LOGGER.log(Level.INFO, "Initialization successful ".concat(initializer.toString()));
        }
        catch (SDKException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SDKException("Exception in initialization : ", e);
        }
    }

    private static JSONObject getJSONDetails() throws IOException, SDKException {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String fileContent = "";
        try {
            String line;
            is = Initializer.class.getResourceAsStream("/resources/JSONDetails.json");
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                fileContent = fileContent + line;
            }
        }
        catch (Exception e) {
            throw new SDKException("Exception in loading JSONDetails : ", e);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return new JSONObject(fileContent);
    }

    private static void switchUser(UserSignature user, DataCenter.Environment environment, Token token, SDKConfig sdkConfig, RequestProxy proxy) throws SDKException {
        Initializer initializer = new Initializer();
        initializer.user = user;
        initializer.environment = environment;
        initializer.token = token;
        initializer.store = Initializer.initializer.store;
        initializer.sdkConfig = sdkConfig;
        initializer.resourcePath = Initializer.initializer.resourcePath;
        initializer.requestProxy = proxy;
        LOCAL.set(initializer);
        LOGGER.log(Level.INFO, "Initialization switched ".concat(initializer.toString()));
    }

    public static JSONObject getJSON(String filePath) throws IOException {
        return new JSONObject(new String(Files.readAllBytes(Paths.get(filePath, new String[0]))));
    }

    public static Initializer getInitializer() {
        if (LOCAL.get() != null) {
            return LOCAL.get();
        }
        return initializer;
    }

    public DataCenter.Environment getEnvironment() {
        return this.environment;
    }

    public TokenStore getStore() {
        return this.store;
    }

    public UserSignature getUser() {
        return this.user;
    }

    public Token getToken() {
        return this.token;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public RequestProxy getRequestProxy() {
        return this.requestProxy;
    }

    public SDKConfig getSDKConfig() {
        return this.sdkConfig;
    }

    protected void finalize() throws Throwable {
        LOCAL.remove();
    }

    public String toString() {
        return "for Email Id : " + Initializer.getInitializer().getUser().getEmail() + " in Environment : " + Initializer.getInitializer().getEnvironment().getUrl() + ".";
    }

    public static class Builder {
        private DataCenter.Environment environment;
        private TokenStore store;
        private UserSignature user;
        private Token token;
        private String resourcePath;
        private RequestProxy requestProxy;
        private SDKConfig sdkConfig;
        private com.zoho.api.logger.Logger logger;
        private String errorMessage;

        public Builder() {
            String string = this.errorMessage = initializer != null ? "SWITCH USER ERROR" : "INITIALIZATION ERROR";
            if (Initializer.getInitializer() != null) {
                Initializer previousInitializer = Initializer.getInitializer();
                this.user = previousInitializer.user;
                this.environment = previousInitializer.environment;
                this.token = previousInitializer.token;
                this.sdkConfig = previousInitializer.sdkConfig;
            }
        }

        public void initialize() throws Exception {
            Utility.assertNotNull(this.user, this.errorMessage, "UserSignature MUST NOT be null.");
            Utility.assertNotNull(this.environment, this.errorMessage, "Environment MUST NOT be null.");
            Utility.assertNotNull(this.token, this.errorMessage, "Token MUST NOT be null.");
            if (this.store == null) {
                this.store = new FileStore(System.getProperty("user.dir") + File.separator + "sdk_tokens.txt");
            }
            if (this.sdkConfig == null) {
                this.sdkConfig = new SDKConfig.Builder().build();
            }
            if (this.resourcePath == null) {
                this.resourcePath = System.getProperty("user.dir");
            }
            if (this.logger == null) {
                this.logger = new Logger.Builder().level(Logger.Levels.INFO).filePath(System.getProperty("user.dir") + File.separator + "sdk_logs.log").build();
            }
            Initializer.initialize(this.user, this.environment, this.token, this.store, this.sdkConfig, this.resourcePath, this.logger, this.requestProxy);
        }

        public void switchUser() throws SDKException {
            Utility.assertNotNull(initializer, "SDK UNINITIALIZED ERROR", "SDK is UnInitialized");
            Initializer.switchUser(this.user, this.environment, this.token, this.sdkConfig, this.requestProxy);
        }

        public Builder logger(com.zoho.api.logger.Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder token(Token token) throws SDKException {
            Utility.assertNotNull(token, this.errorMessage, "Token MUST NOT be null.");
            this.token = token;
            return this;
        }

        public Builder SDKConfig(SDKConfig sdkConfig) throws SDKException {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public Builder requestProxy(RequestProxy requestProxy) {
            this.requestProxy = requestProxy;
            return this;
        }

        public Builder resourcePath(String resourcePath) throws SDKException {
            if (!new File(resourcePath).isDirectory()) {
                throw new SDKException(this.errorMessage, "Resource Path MUST be a valid directory.");
            }
            this.resourcePath = resourcePath;
            return this;
        }

        public Builder user(UserSignature user) throws SDKException {
            Utility.assertNotNull(user, this.errorMessage, "UserSignature MUST NOT be null.");
            this.user = user;
            return this;
        }

        public Builder store(TokenStore store) throws SDKException {
            this.store = store;
            return this;
        }

        public Builder environment(DataCenter.Environment environment) throws SDKException {
            Utility.assertNotNull(environment, this.errorMessage, "Environment MUST NOT be null.");
            this.environment = environment;
            return this;
        }
    }
}

