/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Choice;
import com.zoho.crm.api.util.CommonAPIHandler;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Converter {
    protected CommonAPIHandler commonAPIHandler;

    public Converter() {
    }

    public Converter(CommonAPIHandler commonAPIHandler) {
        this.commonAPIHandler = commonAPIHandler;
    }

    public abstract Object getResponse(Object var1, String var2) throws Exception;

    public abstract Object formRequest(Object var1, String var2, Integer var3, JSONObject var4) throws Exception;

    public abstract void appendToRequest(HttpEntityEnclosingRequestBase var1, Object var2) throws Exception;

    public abstract Object getWrappedResponse(Object var1, String var2) throws Exception;

    public boolean valueChecker(String className, String memberName, JSONObject keyDetails, Object value, HashMap<String, ArrayList<Object>> uniqueValuesMap, Integer instanceNumber) throws SDKException {
        JSONObject detailsJO = new JSONObject();
        String name = keyDetails.getString("name");
        String type = keyDetails.getString("type");
        String varType = null;
        Boolean check = true;
        if (value != null) {
            if (keyDetails.has("interface") && keyDetails.getBoolean("interface")) {
                JSONObject interfaceDetail = Initializer.jsonDetails.getJSONObject(keyDetails.getString("structure_name"));
                JSONArray classes = interfaceDetail.getJSONArray("classes");
                check = false;
                for (Object eachClass : classes) {
                    if (!value.getClass().getCanonicalName().equalsIgnoreCase(eachClass.toString())) continue;
                    check = true;
                    break;
                }
            } else {
                varType = value.getClass().getCanonicalName();
                check = varType.equalsIgnoreCase(type);
            }
        }
        if (value instanceof List) {
            Boolean expectedListType = true;
            if (keyDetails.has("structure_name")) {
                String structureName = keyDetails.getString("structure_name");
                int index = 0;
                List listValue = (List)value;
                for (Object data : listValue) {
                    className = data.getClass().getCanonicalName();
                    if (!className.equalsIgnoreCase(structureName)) {
                        instanceNumber = index;
                        type = "java.util.List(" + structureName + ")";
                        varType = "java.util.List(" + className + ")";
                        expectedListType = false;
                        check = false;
                        break;
                    }
                    ++index;
                }
            }
            if (expectedListType.booleanValue()) {
                check = varType.equalsIgnoreCase(type) ? true : varType.equalsIgnoreCase("java.util.ArrayList");
            }
        } else if (value instanceof Map) {
            check = varType.equalsIgnoreCase(type) ? true : varType.equalsIgnoreCase("java.util.HashMap");
        }
        if (!check.booleanValue() && !type.equalsIgnoreCase("java.lang.Object")) {
            detailsJO.put("field", (Object)memberName);
            detailsJO.put("class", (Object)className);
            detailsJO.put("index", (Object)instanceNumber);
            detailsJO.put("expected-type", (Object)type);
            detailsJO.put("given-type", (Object)varType);
            throw new SDKException("TYPE ERROR", detailsJO);
        }
        if (keyDetails.has("values") && (!keyDetails.has("picklist") || keyDetails.getBoolean("picklist") && Initializer.getInitializer().getSDKConfig().getPickListValidation())) {
            List pickListValue;
            JSONArray valuesJA = keyDetails.getJSONArray("values");
            if (value instanceof Choice) {
                Choice choice = (Choice)value;
                value = choice.getValue();
            }
            if (!(pickListValue = IntStream.range(0, valuesJA.length()).mapToObj(arg_0 -> ((JSONArray)valuesJA).get(arg_0)).map(Object::toString).collect(Collectors.toList())).contains(value.toString())) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("index", (Object)instanceNumber);
                detailsJO.put("given-value", value);
                detailsJO.put("accepted-values", (Object)valuesJA);
                throw new SDKException("UNACCEPTED VALUES ERROR", detailsJO);
            }
        }
        if (keyDetails.has("unique")) {
            ArrayList<Object> valuesArray = uniqueValuesMap.get(name);
            if (valuesArray != null && valuesArray.contains(value)) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("first-index", valuesArray.indexOf(value));
                detailsJO.put("next-index", (Object)instanceNumber);
                throw new SDKException("UNIQUE KEY ERROR", detailsJO);
            }
            if (valuesArray == null) {
                valuesArray = new ArrayList();
            }
            valuesArray.add(value);
            uniqueValuesMap.put(name, valuesArray);
        }
        if (keyDetails.has("min-length") || keyDetails.has("max-length")) {
            int count = value.toString().length();
            if (value instanceof List) {
                count = ((List)value).size();
            }
            if (keyDetails.has("max-length") && count > keyDetails.getInt("max-length")) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("given-length", count);
                detailsJO.put("maximum-length", keyDetails.getInt("max-length"));
                throw new SDKException("MAXIMUM LENGTH ERROR", detailsJO);
            }
            if (keyDetails.has("min-length") && count < keyDetails.getInt("min-length")) {
                detailsJO.put("field", (Object)memberName);
                detailsJO.put("class", (Object)className);
                detailsJO.put("given-length", count);
                detailsJO.put("minimum-length", keyDetails.getInt("min-length"));
                throw new SDKException("MINIMUM LENGTH ERROR", detailsJO);
            }
        }
        if (keyDetails.has("regex") && !Pattern.matches(keyDetails.getString("regex"), String.valueOf(value))) {
            detailsJO.put("field", (Object)memberName);
            detailsJO.put("class", (Object)className);
            detailsJO.put("instance-number", (Object)instanceNumber);
            throw new SDKException("REGEX MISMATCH ERROR", detailsJO);
        }
        return true;
    }

    public String getEncodedFileName() throws UnsupportedEncodingException {
        String fileName = Initializer.getInitializer().getUser().getEmail();
        fileName = fileName.substring(0, fileName.indexOf("@")) + Initializer.getInitializer().getEnvironment().getUrl();
        byte[] input = fileName.getBytes("UTF-8");
        String str = Base64.getEncoder().encodeToString(input);
        return str + ".json";
    }
}

