/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIHTTPConnector;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Utility;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthToken
implements Token {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private String clientID;
    private String clientSecret;
    private String redirectURL;
    private String grantToken;
    private String refreshToken;
    private String accessToken;
    private String expiresIn;
    private String userMail;
    private String id;

    public String getClientId() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getGrantToken() {
        return this.grantToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setClientId(String clientID) {
        this.clientID = clientID;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setGrantToken(String grantToken) {
        this.grantToken = grantToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String userMail) {
        this.userMail = userMail;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public synchronized void authenticate(APIHTTPConnector urlConnection) throws SDKException {
        Initializer initializer = Initializer.getInitializer();
        TokenStore store = initializer.getStore();
        UserSignature user = initializer.getUser();
        OAuthToken oauthToken = this.accessToken == null ? (this.id != null ? (OAuthToken)store.getTokenById(this.id, this) : (OAuthToken)store.getToken(initializer.getUser(), this)) : this;
        String token = "";
        if (oauthToken == null) {
            token = this.refreshToken != null ? this.refreshAccessToken(user, store).getAccessToken() : this.generateAccessToken(user, store).getAccessToken();
        } else if (oauthToken.getExpiresIn() != null && Long.valueOf(oauthToken.getExpiresIn()) - System.currentTimeMillis() < 5000L) {
            LOGGER.log(Level.INFO, "Access Token has expired. Hence refreshing.");
            token = oauthToken.refreshAccessToken(user, store).getAccessToken();
        } else {
            token = oauthToken.getAccessToken();
        }
        urlConnection.addHeader("Authorization", "Zoho-oauthtoken " + token);
    }

    private String getResponseFromServer(HashMap<String, String> requestParams) throws SDKException {
        try {
            String USER_AGENT = "Mozilla/5.0";
            String url = Initializer.getInitializer().getEnvironment().getAccountsUrl();
            CloseableHttpClient client = this.getHttpClient();
            HttpPost post = new HttpPost(url);
            post.setHeader("user-agent", "Mozilla/5.0");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            if (requestParams != null && requestParams.size() > 0) {
                for (String key : requestParams.keySet()) {
                    urlParameters.add(new BasicNameValuePair(key, requestParams.get(key)));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new SDKException(ex);
        }
    }

    private CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SSLContext sslContext = SSLContext.getDefault();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
    }

    private OAuthToken refreshAccessToken(UserSignature user, TokenStore store) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", this.clientID);
        requestParams.put("client_secret", this.clientSecret);
        requestParams.put("grant_type", "refresh_token");
        requestParams.put("refresh_token", this.refreshToken);
        String response = this.getResponseFromServer(requestParams);
        try {
            this.parseResponse(response);
            if (this.id == null) {
                this.generateId();
            }
            store.saveToken(user, this);
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in saving tokens : ", ex);
        }
        return this;
    }

    private OAuthToken generateAccessToken(UserSignature user, TokenStore store) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", this.clientID);
        requestParams.put("client_secret", this.clientSecret);
        if (this.redirectURL != null) {
            requestParams.put("redirect_uri", this.redirectURL);
        }
        requestParams.put("grant_type", "authorization_code");
        requestParams.put("code", this.grantToken);
        String response = this.getResponseFromServer(requestParams);
        try {
            this.parseResponse(response);
            this.generateId();
            store.saveToken(user, this);
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in saving tokens : ", ex);
        }
        return this;
    }

    private OAuthToken parseResponse(String response) throws SDKException {
        try {
            JSONObject responseJSON = new JSONObject(response);
            if (!responseJSON.has("access_token")) {
                throw new SDKException("INVALID TOKEN ERROR", responseJSON.has("error") ? responseJSON.getString("error") : "ACCESS TOKEN IS NOT PRESENT IN RESPONSE");
            }
            this.setAccessToken(responseJSON.getString("access_token"));
            this.setExpiresIn(String.valueOf(this.getTokenExpiresIn(responseJSON)));
            if (responseJSON.has("refresh_token")) {
                this.refreshToken = responseJSON.getString("refresh_token");
            }
        }
        catch (JSONException ex) {
            throw new SDKException("Exception in parsing token response", (Exception)((Object)ex));
        }
        return this;
    }

    private Long getTokenExpiresIn(JSONObject response) {
        return System.currentTimeMillis() + (response.has("expires_in_sec") ? response.getLong("expires_in") : (long)(response.getInt("expires_in") * 1000));
    }

    @Override
    public Boolean remove() throws SDKException {
        try {
            Initializer.getInitializer().getStore().deleteToken(this);
            return true;
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException(ex);
        }
    }

    private OAuthToken(String clientID, String clientSecret, String grantToken, String refreshToken, String redirectURL, String id, String accessToken) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.grantToken = grantToken;
        this.refreshToken = refreshToken;
        this.redirectURL = redirectURL;
        this.accessToken = accessToken;
        this.id = id;
    }

    private void generateId() {
        StringBuilder builder = new StringBuilder();
        String email = Initializer.getInitializer().getUser().getEmail();
        builder.append("java_").append(email.substring(0, email.indexOf("@"))).append("_");
        builder.append(Initializer.getInitializer().getEnvironment().getName()).append("_");
        builder.append(this.refreshToken.substring(this.refreshToken.length() - 4));
        this.id = builder.toString();
    }

    public static class Builder {
        private String clientID;
        private String clientSecret;
        private String redirectURL;
        private String refreshToken;
        private String grantToken;
        private String accessToken;
        private String id;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder clientID(String clientID) throws SDKException {
            Utility.assertNotNull(clientID, "TOKEN ERROR", "ClientID MUST NOT be null");
            this.clientID = clientID;
            return this;
        }

        public Builder clientSecret(String clientSecret) throws SDKException {
            Utility.assertNotNull(clientSecret, "TOKEN ERROR", "ClientSecret MUST NOT be null");
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public OAuthToken build() throws SDKException {
            if (this.grantToken == null && this.refreshToken == null && this.id == null && this.accessToken == null) {
                throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :-" + Constants.OAUTH_MANDATORY_KEYS);
            }
            return new OAuthToken(this.clientID, this.clientSecret, this.grantToken, this.refreshToken, this.redirectURL, this.id, this.accessToken);
        }
    }
}

