/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.DataTypeConverter;
import java.util.HashMap;

public class ParameterMap {
    private HashMap<String, String> parameterMap = new HashMap();

    public HashMap<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public <T> void add(Param<T> param, T value) throws SDKException {
        if (param == null) {
            throw new SDKException("NULL PARAMETER ERROR", "Param Instance MUST NOT be null");
        }
        String paramName = param.getName();
        if (paramName == null) {
            throw new SDKException("NULL PARAM NAME ERROR", "Param Name MUST NOT be null");
        }
        if (value == null) {
            throw new SDKException("NULL PARAMETER ERROR", paramName + " MUST NOT be null");
        }
        String paramValue = null;
        try {
            paramValue = DataTypeConverter.postConvert(value, value.getClass().getName()).toString();
        }
        catch (Exception e) {
            paramValue = value.toString();
        }
        if (this.parameterMap.containsKey(paramName) && !this.parameterMap.get(paramName).isEmpty()) {
            String existingParamValue = this.parameterMap.get(paramName);
            existingParamValue = existingParamValue + "," + paramValue;
            this.parameterMap.put(paramName, existingParamValue);
        } else {
            this.parameterMap.put(paramName, paramValue);
        }
    }
}

