/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.sharerecords;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.sharerecords.ActionHandler;
import com.zoho.crm.api.sharerecords.BodyWrapper;
import com.zoho.crm.api.sharerecords.DeleteActionHandler;
import com.zoho.crm.api.sharerecords.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;

public class ShareRecordsOperations {
    private String moduleAPIName;
    private Long recordId;

    public ShareRecordsOperations(Long recordId, String moduleAPIName) {
        this.recordId = recordId;
        this.moduleAPIName = moduleAPIName;
    }

    public APIResponse<ResponseHandler> getSharedRecordDetails(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2.1/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/actions/share");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> shareRecord(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2.1/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/actions/share");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateSharePermissions(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2.1/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/actions/share");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<DeleteActionHandler> revokeSharedRecord() throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2.1/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/actions/share");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(DeleteActionHandler.class, "application/json");
    }

    public static class GetSharedRecordDetailsParam {
        public static final Param<Long> SHAREDTO = new Param("sharedTo", "com.zoho.crm.api.ShareRecords.GetSharedRecordDetailsParam");
        public static final Param<String> VIEW = new Param("view", "com.zoho.crm.api.ShareRecords.GetSharedRecordDetailsParam");
    }
}

